/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.logging.LogUtils;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.util.SignatureUpdater;
import org.slf4j.Logger;

public interface SignatureValidator {
    public static final SignatureValidator NO_VALIDATION = (p_216352_, p_216353_) -> true;
    public static final Logger LOGGER = LogUtils.getLogger();

    public boolean validate(SignatureUpdater var1, byte[] var2);

    default public boolean validate(byte[] p_216376_, byte[] p_216377_) {
        return this.validate(p_216374_ -> p_216374_.update(p_216376_), p_216377_);
    }

    private static boolean verifySignature(SignatureUpdater p_216355_, byte[] p_216356_, Signature p_216357_) throws SignatureException {
        p_216355_.update(p_216357_::update);
        return p_216357_.verify(p_216356_);
    }

    public static SignatureValidator from(PublicKey p_216370_, String p_216371_) {
        return (p_216367_, p_216368_) -> {
            try {
                Signature $$4 = Signature.getInstance(p_216371_);
                $$4.initVerify(p_216370_);
                return SignatureValidator.verifySignature(p_216367_, p_216368_, $$4);
            }
            catch (Exception $$5) {
                LOGGER.error("Failed to verify signature", (Throwable)$$5);
                return false;
            }
        };
    }

    @Nullable
    public static SignatureValidator from(ServicesKeySet p_285388_, ServicesKeyType p_285383_) {
        Collection $$2 = p_285388_.keys(p_285383_);
        if ($$2.isEmpty()) {
            return null;
        }
        return (p_284690_, p_284691_) -> $$2.stream().anyMatch(p_216361_ -> {
            Signature $$3 = p_216361_.signature();
            try {
                return SignatureValidator.verifySignature(p_284690_, p_284691_, $$3);
            }
            catch (SignatureException $$4) {
                LOGGER.error("Failed to verify Services signature", (Throwable)$$4);
                return false;
            }
        });
    }
}

